/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 用户创建接口
 *
 * @author
 * @version FuStdCustomerCreateRes.java, v 0.1 2024-01-02 10:33:53
 */
@Data
public class FuStdCustomerCreateRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555513752569L;


    /**
     * 商户流水号
     * 商户流水号，唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 旷世验证 h5 链接
     * 旷世验证 h5 链接
     * (选填)
     */
    private String ksCheckUrl;

    /**
     * 阿里验证 h5 链接
     * 阿里验证 h5 链接
     * (选填)
     */
    private String checkUrl;

}