/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;


import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 *
 *
 * @author
 * @version FuStdQueryAccountInSettleRequest.java, v 0.1 2024-03-21 15:44:47
 */
@Data
public class FuStdQueryAccountInSettleReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555717047153L;


    /**
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 富友批次号
     * (富友参考号、富友源交易批次号、商户流水号、商户子流水号四选一必填)
     */
    @Length(max = 30, message = "batchNo长度不能超过30")
    @NoSign
    private String batchNo;

    /**
     * 富友交易参考号
     * (富友参考号、富友源交易批次号、商户流水号、商户子流水号四选一必填)
     */
    @Length(max = 30, message = "srcFasSsn长度不能超过30")
    @NoSign
    private String srcFasSsn;

    /**
     * 源交易商户流水号
     * (富友参考号、富友源交易批次号、商户流水号、商户子流水号四选一必填)
     */
    @Length(max = 30, message = "mchntCdTraceNo长度不能超过30")
    @NoSign
    private String mchntCdTraceNo;

    /**
     * 源交易商户子流水号
     * (富友参考号、富友源交易批次号、商户流水号、商户子流水号四选一必填)
     */
    @Length(max = 30, message = "mchntCdChildTraceNo长度不能超过30")
    @NoSign
    private String mchntCdChildTraceNo;

    /**
     * 用户编号
     * (必填)
     */
    @NotBlank
    @Length(max = 27, message = "accountIn长度不能超过27")
    private String accountIn;

}