package com.fshows.fuiou.response.merchant; /**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouSignCallbackResponse.java, v 0.1 2024-11-27 09:50:58
 */
@Data
public class FuiouSignCallbackResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555511018356L;


    /**
     * 商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 响应结果
     * (必填)
     */
    private String retCode;

    /**
     * 响应对应中文解释
     * (必填)
     */
    private String retMsg;

    /**
     * 请求交易流水
     * (必填)
     */
    private String traceNo;

    /**
     * 签约单号
     * (必填)
     */
    private String contractNo;

    /**
     * 状态： 1、签约成功 2、签约中 0、签约失败 3、待签约
     * (必填)
     */
    private String result;

    /**
     * 签约成功pdf下载url（签约成功返回链接）
     * (选填)
     */
    private String signPdfUrl;

}