package com.fshows.fuiou.request.merchant; /**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouSignCallbackResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.naming.Name;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouSignCallbackRequest.java, v 0.1 2024-11-27 09:50:58
 */
@Data
public class FuiouSignCallbackRequest extends FuiouBizRequest<FuiouSignCallbackResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555131455601L;

    /**
     * 富友商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 签约单号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "signNo长度不能超过32")
    @JSONField(name = "sign_no")
    private String signNo;

    /**
     * 状态： 1:签约成功 2:签约失败
     * (必填)
     */
    @NotBlank
    @JSONField(name = "result")
    private String result;

    /**
     * 商户状态（0:关闭；1:开通）
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "insTp长度不能超过1")
    @JSONField(name = "ins_tp")
    private String insTp;

}