/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.request.trade.item.FustdAccountInListReq;
import com.fshows.steward.request.trade.item.FustdSrcFasSsnListReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 订单分账接口
 *
 * @author
 * @version FuStdBatchTradeAllocateReq.java, v 0.1 2024-01-02 09:59:27
 */
@Data
public class FuStdBatchTradeAllocateReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555300276830L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 商户自有子账户编号
     * 指定出款的自有子账户，不填模式从商户主账户出款。
     * (选填)
     */
    @Length(max = 30, message = "subAccountIn长度不能超过30")
    private String subAccountIn;

    /**
     * 订单流水号列表
     * 富友支付参考流水号
     * (必填)
     */
    private List<FustdSrcFasSsnListReq> srcFasSsnList;

    /**
     * 源交易日期
     * YYYYMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "srcFasDate长度不能超过8")
    private String srcFasDate;

    /**
     * 入账方列表
     *
     * (必填)
     */
    @NotNull
    private List<FustdAccountInListReq> accountInlist;


}