/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.pay;

import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouJsApiPayResponse.java, v 0.1 2023-07-05 11:15:53
 */
@Data
public class FuiouJsApiPayResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555499723829L;


    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 支付通道对应的子商户识别码
     *
     * (选填)
     */
    private String subMerId;

    /**
     * 预支付交易会话标识
     *
     * (选填)
     */
    @Length(max = 64, message = "sessionId长度不能超过64")
    private String sessionId;

    /**
     * 二维码链接 trade_type 为 APPLEPAY、UNIONPAY时返回，用以重定向拉起支付
     *
     * (选填)
     */
    @Length(max = 64, message = "qrCode长度不能超过64")
    private String qrCode;

    /**
     * 子商户公众号id
     *
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 子商户用户标识
     *
     * (选填)
     */
    @Length(max = 128, message = "subOpenid长度不能超过128")
    private String subOpenid;

    /**
     * 公众号id
     *
     * (选填)
     */
    @Length(max = 16, message = "sdkAppid长度不能超过16")
    private String sdkAppid;

    /**
     * 时间戳，自1970年1月1日 0点0分0秒以来的秒数
     *
     * (选填)
     */
    @Length(max = 32, message = "sdkTimestamp长度不能超过32")
    private String sdkTimestamp;

    /**
     * 随字符串
     *
     * (选填)
     */
    @Length(max = 32, message = "sdkNoncestr长度不能超过32")
    private String sdkNoncestr;

    /**
     * 订单性情扩展字符串
     *
     * (选填)
     */
    @Length(max = 128, message = "sdkPackage长度不能超过128")
    private String sdkPackage;

    /**
     * 签名方式，trade_type 为 JSAPI、LETPAY时才返回
     *
     * (选填)
     */
    @Length(max = 32, message = "sdkSigntype长度不能超过32")
    private String sdkSigntype;

    /**
     * 签名
     *
     * (选填)
     */
    @Length(max = 512, message = "sdkPaysign长度不能超过512")
    private String sdkPaysign;

    /**
     * trade_type 为 APP时才返回
     *
     * (选填)
     */
    @Length(max = 32, message = "sdkPartnerid长度不能超过32")
    private String sdkPartnerid;

    /**
     * 富友生成的订单号,需要商户与商户订单号进行关联
     *
     * (选填)
     */
    @Length(max = 30, message = "reservedFyOrderNo长度不能超过30")
    private String reservedFyOrderNo;

    /**
     * 富友交易日期
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedFySettleDt长度不能超过8")
    private String reservedFySettleDt;

    /**
     * 渠道交易流水号 trade_type 为 FWC、MPAY时返回（用于调起支付）
     *
     * (选填)
     */
    @Length(max = 64, message = "reservedTransactionId长度不能超过64")
    private String reservedTransactionId;

    /**
     * 富友系统内部追踪号
     *
     * (选填)
     */
    @Length(max = 12, message = "reservedFyTraceNo长度不能超过12")
    private String reservedFyTraceNo;

    /**
     * 支付参数
     *
     * (选填)
     */
    private String reservedPayInfo;

    /**
     * 条码流水号，用户账单二维码对应的流水
     *
     * (选填)
     */
    @Length(max = 64, message = "reservedChannelOrderId长度不能超过64")
    private String reservedChannelOrderId;

    /**
     * 附加数据
     *
     * (选填)
     */
    @Length(max = 50, message = "reservedAddnInf长度不能超过50")
    private String reservedAddnInf;

}