/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.order;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.response.base.FuiouBankPayBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouBankCardPayOrderQueryResponse.java, v 0.1 2023-07-05 10:54:02
 */
@Data
public class FuiouBankCardPayOrderQueryResponse extends FuiouBankPayBizResponse implements Serializable {

    private static final long serialVersionUID = 7854792234008057313L;
    /**
     * 外部订单号
     */
    private String inOrderNo;

    /**
     * 版本号
     */
    private String version;

    /**
     * 机构号
     */
    private String insCd;

    /**
     * 富友商户号
     */
    private String merchantnoFuiou;

    /**
     * 卡属性, 卡属性, 01借记卡, 02信用卡, 03准贷记卡,04预付卡
     */
    private String cardType;

    /**
     * 交易类型： 1 微信 2支付宝 3银行卡 4现金 5无卡支付 6qq钱包 7百度钱包 8京东钱包
     */
    private String payType;

    /**
     * 1主扫  2被扫. 扫码类交易存在
     */
    private String scanType;

    /**
     * 富友终端号
     */
    private String terminalId;

    /**
     * 富友支付订单号(系统参考号)
     */
    private String outTradeNo;

    /**
     * 扫码支付参考号(系统参考号)
     */
    private String retriFefNo;

    /**
     * 富友退款订单号(原参考号)，撤销、退款交易时存在
     */
    private String outRefundNo;

    /**
     * 通道订单号,渠道返回订单号
     */
    private String channelTradeNo;

    /**
     * 交易状态 1支付成功，2退款成功，3撤销成功，4冲正成功
     */
    private String payStatus;

    /**
     * 交易状态描述：1.支付成功，2退款成功，3撤销成功，4冲正成功
     */
    private String payMsg;

    /**
     * 总交易金额：支付金额，金额分
     */
    private String totalFee;

    /**
     * 退款金额，金额分
     */
    private String refundFee;

    /**
     * 交易时间. yyyyMMddHHmmss
     */
    private String createtime;

    /**
     * 富友清算日期. yyyyMMdd
     */
    private String settleDate;

    /**
     * 交易加密卡号(MD5+salt)
     */
    @JSONField(name = "cardno_encrypt")
    private String cardnoEncrypt;

    /**
     * 交易卡号(前6后4)
     */
    private String cardno;

    /**
     * 发卡行代码
     */
    private String issuer;

    /**
     * 凭证号
     */
    private String terminalTrace;

    /**
     * 备注
     */
    private String reference;

    /**
     * 买家在渠道账号
     */
    private String buyerId;

    /**
     * 签名. 传入验证的签名
     */
    private String keySign;

    /**
     * 手续费，金额分
     */
    private String feeAmt;

    /**
     * 渠道响应码
     */
    private String kbpsRspCd;

    /**
     * 渠道响应码说明
     */
    private String kbpsRspDesc;
}