/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author
 * @version FuiouSubMerchantQueryResponse.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouSubMerchantQueryResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555946498790L;


    /**
     * 唯一流水号
     * (选填)
     */
    private String traceNo;

    /**
     * 返回码 SUCCESS： FAIL：系统异常
     * (必填)
     */
    private String returnCode;

    /**
     * 返回信息，如非空，为错误原因:签名失败，参数格式校验错误
     * (选填)
     */
    private String returnMsg;

    /**
     * 富友商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 业务结果代码
     */
    private String resultCode;

    /**
     * 业务结果返回信息
     */
    private String resultMsg;

    /**
     * 挂靠一级商户号(微信)
     */
    private String linkMchntCd;

    /**
     * 挂靠一级商户号（支付宝）
     */
    private String aliLinkMchntCd;

    /**
     * 商户子商户号
     * （只有 return_code 和 result_code 同时成功才有返回）
     */
    private String subMchId;

    /**
     * 微信渠道号
     * （只有 return_code 和 result_code 同时成功才有返回，并且mchnt_tp为微信或者微信绿洲有返回）
     */
    private String wxChannelNo;
}