/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.request.settlement;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.settlement.FuiouSettlementApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.settlement.FuiouWithdrawResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhaoxumin
 * @version FuiouWithdrawRequest.java, v 0.1 2024-01-07 zhaoxumin
 */
@Data
public class FuiouWithdrawRequest extends FuiouBizRequest<FuiouWithdrawResponse, FuiouSettlementApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -5304602650427087798L;
    /**
     * 商户号, 富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 商户内部提现单号
     */
    @Length(max = 30, message = "reserved_order_no长度不能超过30")
    @JSONField(name = "reserved_order_no")
    private String reservedOrderNo;

    /**
     * 待结算总金额
     */
    @NotNull
    @JSONField(name = "amt")
    private BigDecimal amt;

    /**
     * 待结算已转结金额（txn_type为3时必传）
     */
    @JSONField(name = "reserved_settled_amt")
    private BigDecimal reservedSettledAmt;

    /**
     * 待结算未转结金额（txn_type为3时必传）
     */
    @JSONField(name = "reserved_not_settle_amt")
    private BigDecimal reservedNotSettleAmt;

    /**
     * 手续费金额
     */
    @NotNull
    @JSONField(name = "fee_amt")
    private BigDecimal feeAmt;

    /**
     * 1：未转结金额结算
     * 2：已转结金额结算
     * 3：合并结算（已转结+未转结 同时结算，一笔到账）
     * 4：交班到账
     * 5：合并结算（全额外扣）
     */
    @NotBlank
    @Length(max = 1, message = "txn_type长度不能超过1")
    @JSONField(name = "txn_type")
    private String txnType;

    /**
     * 附言（注：交班到账上送附言不生效）
     */
    @Length(max = 100, message = "reserved_postscript长度不能超过100")
    @JSONField(name = "reserved_postscript")
    private String reservedPostscript;

    /**
     * 是否免除全额外扣手续费，0不免 1免
     */
    @Length(max = 1, message = "reserved_is_full_extra_deduction_free长度不能超过1")
    @JSONField(name = "reserved_is_full_extra_deduction_free")
    private String reservedIsFullExtraDeductionFree;
}