/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhubo
 * @version WechatConfigInfoRequest.java, v 0.1 2023-09-14 17:35 zhubo
 */
@Data
public class FuiouWechatConfigInfoRequest implements Serializable {
    private static final long serialVersionUID = 3850048468731615651L;

    /**
     * 富友商户号
     * (选填)
     */
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * JSAPI 支付授权目录
     * (选填)
     */
    @Length(max = 256, message = "jsapiPath长度不能超过256")
    private String jsapiPath;

    /**
     * 子商户 SubAPPID
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 子商户推荐关注公众账号 APPID
     * (选填)
     */
    @Length(max = 15, message = "subscribeAppid长度不能超过15")
    private String subscribeAppid;

    @Override
    public String toString() {
        return "{" +
                "mchntCd:'" + mchntCd + '\'' +
                ", jsapiPath:'" + jsapiPath + '\'' +
                ", subAppid:'" + subAppid + '\'' +
                ", subscribeAppid:'" + subscribeAppid + '\'' +
                '}';
    }
}
