package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouTermCollectResponse;
import lombok.Data;

import java.io.Serializable;

@Data
public class FuiouTermCollectRequest extends FuiouBizRequest<FuiouTermCollectResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = 7257198158987601491L;


    /**
     * 唯一流水号
     */
    @JSONField(name = "trace_no")
    private String traceNo;
    /**
     * 已在富友入网的富友商户代码 示例：0002900F0468631
     */
    @JSONField(name = "mchnt_cd")
    private String mchntCd;
    /**
     * 操作标识，取值范围：00：新增；01：修改；02：注销；（注销状态，将会拒绝交易）
     */
    @JSONField(name = "handle_type")
    private String handleType;
    /**
     * 富友终端型号
     */
    @JSONField(name = "tm_mode")
    private String tmMode;
    /**
     * 终端设备状态(启用、注销) 00：启用；01：注销；（注销状态，将会拒绝交易）
     */
    @JSONField(name = "tm_device_state")
    private String tmDeviceState;
    /**
     * 填写厂家提供的TUSN号，格式为：[8位数字(8位数字为：6位厂商编号+2位终端类型)+SN]，总长度大于等于16位，eg:00000104188SCA8U1514 注意：TUSN号一定要填写准确！如果厂家没有TUSN或者没有实体终端，本字段则填写：[mchnt_cd + SN号]或者[mchnt_cd + 合作方的虚拟终端号] eg:0002900F04686310000000001此字段后续填入交易的reserved_terminal_info.serial_num字段中。
     */
    @JSONField(name = "tm_serial_no")
    private String tmSerialNo;
    /**
     * 终端布放地(省-市-区-详细地址) 例如：四川省-成都市-成华区-双林路339号成都339购物中心A座
     */
    @JSONField(name = "tm_contact_addr")
    private String tmContactAddr;
    /**
     * 经度 (终端布放地)经度必须以W，E 开头
     */
    @JSONField(name = "longitude")
    private String longitude;
    /**
     * 纬度 (终端布放地)纬度必须以N，S开头
     */
    @JSONField(name = "latitude")
    private String latitude;
    /**
     * 终端别称
     */
    @JSONField(name = "tm_name_cn")
    private String tmNameCn;
    /**
     * 终端报备渠道类型:不传或传空，则根据商户开通业务做对应的渠道报备WECHAT（微信）ALIPAY（支付宝）UNIONPAY（银联）
     */
    @JSONField(name = "term_busi_chnl")
    private String termBusiChnl;

}
