/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouCommitFinishResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouCommitFinishRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouCommitFinishRequest extends FuiouBizRequest<FuiouCommitFinishResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555650935142L;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;
    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 发送账密短信标识，默认不发 0不发 1发送
     * (选填)
     */
    @Length(max = 1, message = "pushOpenaccountSms长度不能超过1")
    @JSONField(name = "push_openaccount_sms")
    private String pushOpenaccountSms;

}