package com.fshows.fuiou.enums;

import com.fshows.fuiou.client.base.IFuiouBankPayApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.trade.order.FuiouBankCardPayOrderQueryRequest;
import com.fshows.fuiou.response.trade.order.FuiouBankCardPayOrderQueryResponse;

/**
 * 富友银行卡支付交易相关API
 *
 * @author zhaoxumin
 * @version FuiouBankPayApiDefinitionEnum.java, v 0.1 2023-10-16 10:34
 */
public enum FuiouBankPayApiDefinitionEnum implements IFuiouBankPayApiDefinition {

    BANK_CARD_PAY_ORDER_QUERY(
            "银行卡支付-订单查询接口",
            "/trade/order",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouBankCardPayOrderQueryRequest.class,
            FuiouBankCardPayOrderQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    FuiouBankPayApiDefinitionEnum(String name,
                                  String apiSubURI,
                                  String version,
                                  Class requestClass,
                                  Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}