/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 用户激活、短信重发接口
 *
 * @author
 * @version FuStdActiveCustomerRes.java, v 0.1 2023-12-28 15:31:25
 */
@Data
public class FuStdActiveCustomerRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555667524293L;


    /**
     * 商户流水号
     * 商户流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 用户编号
     * 用户编号
     * (选填)
     */
    private String accountIn;

    /**
     * 旷世验证 h5 链接
     * checkType 为 2 的时候返回
     * (选填)
     */
    private String ksCheckUrl;

    /**
     * 阿里验证 h5 链接
     * checkType 为 2 的时候返回
     * (选填)
     */
    private String checkUrl;

}