/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author
 * @version FuiouAgreementCreateResponse.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouAgreementCreateResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555270458884L;


    /**
     * 流水号
     * (选填)
     */
    private String traceNo;

    /**
     * 响应结果
     * (必填)
     */
    private String retCode;

    /**
     * 响应对应中文解释
     * (必填)
     */
    private String retMsg;

    /**
     * 商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 商户名称
     * (必填)
     */
    private String mchntName;

    /**
     * 验证码失效时间(yyyyMMdd HHss)
     * (必填)
     */
    private String expireTs;

    /**
     * 验证码
     * (必填)
     */
    private String verifyNo;

    /**
     * 协议编号
     * (必填)
     */
    private String contractNo;

    /**
     * 协议签署服务地址
     * (必填)
     */
    private String signUrl;

}