/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouCallbackAddressResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouCallbackAddressRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouCallbackAddressRequest extends FuiouBizRequest<FuiouCallbackAddressResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555863518977L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 0关闭，1开通
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "notifyEmailFlag长度不能超过1")
    private String notifyEmailFlag;

    /**
     * 回调url
     * (选填)
     */
    private String notifyUrl;

    /**
     * 0关闭，1开通
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "notifyUrlFlag长度不能超过1")
    private String notifyUrlFlag;

    /**
     * 回调通知类型： 渠道报备通知：report； 整改协查通知：mchtreform 收单审核结果通知：accept
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "notifyType长度不能超过10")
    private String notifyType;

    /**
     * 回调email，多邮箱时用”,”分隔（英文逗号）。如：”A@fuiou.com,B@fuiou.com”
     * (选填)
     */
    @Length(max = 512, message = "notifyEmails长度不能超过512")
    private String notifyEmails;

}