/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.fgj.FuiouFgjApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.fgj.FuiouFgjStatusQueryResponse;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FgjCreateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouFgjStatusQueryRequest extends FuiouBizRequest<FuiouFgjStatusQueryResponse, FuiouFgjApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -5244192261653122909L;
    /**
     * 唯一流水号，机构自己定义
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "traceNo长度不能超过64")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

}