/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version FuiouFgjShareholderRequest.java, v 0.1 2024-07-23 15:02 zhoujp
 */
@Data
public class FuiouFgjShareholderRequest implements Serializable {
    private static final long serialVersionUID = 1011485921775161849L;


    /**
     * 股东姓名
     * (必填)
     */
    @Length(max = 64, message = "股东姓名长度不能超过64")
    @JSONField(name = "name")
    private String name;

    /**
     * 股东证件类型
     * (必填)
     * 0:身份证
     * 1:护照
     * 2:军官证
     * 9:警察证
     * B:通行证
     * 同“受益人证件类型”
     */
    @Length(max = 1, message = "股东证件类型长度不能超过1")
    @JSONField(name = "certif_tp")
    private String certifTp;

    /**
     * 股东证件号码
     * (必填)
     */
    @Length(max = 24, message = "股东证件号码长度不能超过24")
    @JSONField(name = "certif_id")
    private String certifId;

    /**
     * 股东证件有效期开始日
     */
    @Length(max = 8, message = "股东证件有效期开始日长度不能超过8")
    @JSONField(name = "certif_start_dt")
    private String certifStartDt;

    /**
     * 股东证件有效期到期日
     */
    @Length(max = 8, message = "股东证件有效期到期日长度不能超过8")
    @JSONField(name = "certif_end_dt")
    private String certifEndDt;

    /**
     * 股东手机号
     */
    @Length(max = 11, message = "股东手机号长度不能超过11")
    @JSONField(name = "mobile")
    private String mobile;

    /**
     * 股东地址
     */
    @Length(max = 64, message = "股东地址长度不能超过64")
    @JSONField(name = "address")
    private String address;


}