/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 归集授权申请撤销接口
 *
 * @author
 * @version FuStdCancleConcentrateRelationApplyRes.java, v 0.1 2023-12-28 15:58:13
 */
@Data
public class FuStdCancleConcentrateRelationApplyRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555837018817L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    private String mchntCdConcentrate;

    /**
     * 原授权申请号
     * 授权接口返回的申请号
     * (必填)
     */
    @NotBlank
    private String batchNo;

}