/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.pay;

import com.fshows.fuiou.response.trade.pay.FuiouJsApiPayResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.io.Serializable;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version FuiouJsApiPayRequest.java, v 0.1 2023-07-05 11:15:53
 */
@Data
public class FuiouJsApiPayRequest extends FuiouBizRequest<FuiouJsApiPayResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555996865315L;


    /**
     * 商户号,富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号(没有真实终端号统一填88888888)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 商品名称, 显示在用户账单的商品、商品说明等地方
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "goodsDes长度不能超过128")
    private String goodsDes;

    /**
     * 单品优惠功能字段，见文档中good_detail说明字段
     *
     * (选填)
     */
    @Length(max = 6000, message = "goodsDetail长度不能超过6000")
    private String goodsDetail;

    /**
     * 商品标记
     *
     * (选填)
     */
    @Length(max = 32, message = "goodsTag长度不能超过32")
    private String goodsTag;

    /**
     * 商品标识
     *
     * (选填)
     */
    @Length(max = 32, message = "productId长度不能超过32")
    private String productId;

    /**
     * 附加数据 如果需要用到微信点餐数据回传，该字段需要填写OrderSource=FoodOrder
     *
     * (选填)
     */
    @Length(max = 50, message = "addnInf长度不能超过50")
    private String addnInf;

    /**
     * 商户订单号,商户系统内部的订单号（5到30个字符、只能包含字母数字,区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 货币类型,默认人民币：CNY
     *
     * (选填)
     */
    @Length(max = 3, message = "currType长度不能超过3")
    private String currType;

    /**
     * 总金额,订单总金额,单位为分
     *
     * (必填)
     */
    @NotNull
    private Integer orderAmt;

    /**
     * 实时交易终端IP(后期富友、银联侧风控主要依据，请真实填写) 暂时仅支持IPV4
     *
     * (必填)
     */
    @NotBlank
    private String termIp;

    /**
     * 交易起始时间,订单生成时间,格式为yyyyMMddHHmmss
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 14, message = "txnBeginTs长度不能超过14")
    private String txnBeginTs;

    /**
     * 通知地址,接收富友异步通知回调地址,通知url必须为直接可访问的url,不能携带参数
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 256, message = "notifyUrl长度不能超过256")
    private String notifyUrl;

    /**
     * 限制支付, no_credit:不能使用信用卡 credit_group：不能使用花呗以及信用卡
     *
     * (选填)
     */
    @Length(max = 32, message = "limitPay长度不能超过32")
    private String limitPay;

    /**
     * 订单类型: JSAPI--公众号支付 FWC--支付宝服务窗、支付宝小程序 LETPAY-微信小程序 BESTPAY--翼支付js MPAY--云闪付小程序（控件支付） APPLEPAY--APPLE相机扫码 （监管要求，已停用） UNIONPAY--云闪付扫码 UPBXJS--云闪付保险缴费
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "tradeType长度不能超过16")
    private String tradeType;

    /**
     * 用户标识(暂已废弃,不影响已对接完成的)
     *
     * (选填)
     */
    @Length(max = 128, message = "openid长度不能超过128")
    private String openid;

    /**
     * 子商户用户标识 支付宝服务窗为用户buyer_id(此场景必填) 微信公众号为用户的openid(小程序,公众号,服务窗必填) APPLEPAY（相机扫码）该值不用填 UNIONPAY（云闪付扫码）该值必填
     *
     * (选填)
     */
    @Length(max = 128, message = "subOpenid长度不能超过128")
    private String subOpenid;

    /**
     * 子商户公众号id, 微信交易为商户的appid(小程序,公众号必填)
     *
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 交易关闭时间 默认120min，上限：360min
     *
     * (选填)
     */
    private Integer reservedExpireMinute;

    /**
     * 富友终端号(富友终端号与TUSN号二选一),富友采购或自带机入网填此字段
     *
     * (选填)
     */
    @Length(max = 8, message = "reservedFyTermId长度不能超过8")
    private String reservedFyTermId;

    /**
     * 富友终端类型 0:其他 1:富友终端 2:POS机 3:台卡 4:PC软件
     *
     * (选填)
     */
    @Length(max = 1, message = "reservedFyTermType长度不能超过1")
    private String reservedFyTermType;

    /**
     * 积分抵扣金额,单位为分
     *
     * (选填)
     */
    private Integer reservedTxnBonus;

    /**
     * 终端序列号
     *
     * (选填)
     */
    @Length(max = 20, message = "reservedFyTermSn长度不能超过20")
    private String reservedFyTermSn;

    /**
     * 设备信息，托传给微信。用于单品券核销。
     *
     * (选填)
     */
    @Length(max = 32, message = "reservedDeviceInfo长度不能超过32")
    private String reservedDeviceInfo;

    /**
     * JSON串，花呗分期示例值：{"dynamic_token_out_biz_no":"66666","hb_fq_num":"3","industry_reflux_info":{"scene_code":"metro_tradeorder","channel":"xxxx","scene_data":{"asset_name":"ALIPAY"}},"food_order_type":"qr_order"}信用卡分期示例值：{"fq_num":"3"}银联分期示例值：{"hb_fq_num":"3","industry_reflux_info":"ICBC,ABC,CCB"}
     *
     * (选填)
     */
    private String reservedAliExtendParams;

    /**
     * 门店id（目前仅支持支付宝）
     *
     * (选填)
     */
    @Length(max = 32, message = "reservedStoreCode长度不能超过32")
    private String reservedStoreCode;

    /**
     * 支付宝店铺编号
     *
     * (选填)
     */
    @Length(max = 32, message = "reservedAlipayStoreId长度不能超过32")
    private String reservedAlipayStoreId;

    /**
     * 姓名
     *
     * (选填)
     */
    @Length(max = 20, message = "reservedUserTruename长度不能超过20")
    private String reservedUserTruename;

    /**
     * 身份证
     *
     * (选填)
     */
    @Length(max = 48, message = "reservedUserCreid长度不能超过48")
    private String reservedUserCreid;

    /**
     * 终端信息说明字段，见文档中reserved_terminal_info终端信息说明字段（259号文，终端信息）
     *
     * (选填)
     */
    private String reservedTerminalInfo;

    /**
     * 商户传入业务信息，应用于安全，营销等参数直传场景，格式为 json 格式：{"data":"123"}
     *
     * (选填)
     */
    @Length(max = 512, message = "reservedBusinessParams长度不能超过512")
    private String reservedBusinessParams;

    /**
     * 场景信息说明字段，见文档中reserved_scene_info场景信息说明字段示例
     *
     * (选填)
     */
    @Length(max = 256, message = "reservedSceneInfo长度不能超过256")
    private String reservedSceneInfo;

    /**
     * 云闪付交易（UNIONPAY、MPAY、UPBXJS）支付成功跳转页面
     *
     * (选填)
     */
    @Length(max = 256, message = "reservedFrontUrl长度不能超过256")
    private String reservedFrontUrl;

    /**
     * 云闪付交易（UNIONPAY、MPAY、UPBXJS）支付未完成跳转
     *
     * (选填)
     */
    @Length(max = 256, message = "reservedReservedFrontFailUrl长度不能超过256")
    private String reservedReservedFrontFailUrl;

}