/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.order;

import com.fshows.fuiou.response.trade.order.FuiouOrderCloseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.enums.FuiouApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.io.Serializable;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version FuiouOrderCloseRequest.java, v 0.1 2023-07-05 11:22:18
 */
@Data
public class FuiouOrderCloseRequest extends FuiouBizRequest<FuiouOrderCloseResponse, FuiouApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555422335572L;


    /**
     * 商户号,富友分配给二级商户的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号(没有真实终端号统一填88888888)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 商户订单号, 商户系统内部的订单号 (5到30个字符、只能包含字母数字,区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 订单类型: ALIPAY(统一下单、服务窗支付) WECHAT(统一下单、公众号支付、小程序支付) WXAPP(微信 app) WXH5(微信 h5)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 子商户公众号id，子商户配置多个公众号时必填
     *
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

}