package com.fshows.fuiou.request.merchant; /**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouQueryTerminalResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouQueryTerminalRequest.java, v 0.1 2024-11-27 09:46:21
 */
@Data
public class FuiouQueryTerminalRequest extends FuiouBizRequest<FuiouQueryTerminalResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555919761829L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "traceNo长度不能超过15")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端序列号(与终端id至少二选一)
     * (选填)
     */
    @Length(max = 20, message = "tmSerialNo长度不能超过20")
    private String tmSerialNo;

    /**
     * 终端id(与终端序列号至少二选一)
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

}