/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.coupon;

import com.fshows.fuiou.enums.FuiouCouponDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferQueryResponse;
import com.fshows.fuiou.response.trade.pay.FuiouPreOrderResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouCouponTransferQueryRequest.java, v 0.1 2024-08-16 16:45 mengqf
 */
@Data
public class FuiouCouponTransferQueryRequest extends FuiouBizRequest<FuiouCouponTransferQueryResponse, FuiouCouponDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = 1221984548772763381L;

    /**
     * 营销账号-转出的商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn不能超过40位")
    private String accountIn;

    /**
     * 开始日期 yyyyMMdd
     */
    @NotBlank
    @Length(max = 8, message = "beginDate不能超过8位")
    private String beginDate;

    /**
     * 结束日期 yyyyMMdd
     */
    @NotBlank
    @Length(max = 8, message = "endDate不能超过8位")
    private String endDate;

    /**
     * 唯一流水号-原交易流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo不能超过30位")
    private String traceNo;

    /**
     * 交易状态
     * 1-成功
     * 2-失败
     * 7-超时
     * 空-所有 默认查所有
     */
    @Length(max = 1, message = "status不能超过1位")
    private String status;

    /**
     * 备注
     */
    @Length(max = 128, message = "remark不能超过128位")
    private String remark;
}