/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.response.query.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangyi
 * @version FuStdQueryMchntDrawoutItem.java, v 0.1 2024-11-08 01:38 wangyi
 */
@Data
public class FuStdQueryMchntDrawoutItem {

    /**
     * 富友批次号
     *
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 源交易商户流水号
     * 商户流水号
     * (选填)
     */
    private String mchntTraceNo;

    /**
     * 结算账户类型
     * 01 对私，02 对公
     */
    private String cleanType;

    /**
     * 结算时间
     * yyyy-MM-dd HH:mm:ss
     * (必填)
     */
    @NotBlank
    private String cleanTime;

    /**
     * 状态
     * 01 处理中
     05 成功
     06 失败
     09 退票
     * (必填)
     */
    @NotBlank
    private String status;

    /**
     * 结算手续费
     * 单位：分
     * (必填)
     */
    @NotNull
    private Integer cleanFee;

    /**
     * 结算金额
     * 单位：分
     * (必填)
     */
    @NotNull
    private Integer cleanAmt;

    /**
     * 结算结果描述
     *
     * (必填)
     */
    @NotBlank
    private String cleanDesc;

    /**
     * 结算账号
     */
    private String outAcntNo;
}