/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouOrderRevokedResponse.java, v 0.1 2023-07-05 11:24:11
 */
@Data
public class FuiouOrderRevokedResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555619407420L;


    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 订单类型
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 原交易商户订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

    /**
     * 商户撤销单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "cancelOrderNo长度不能超过30")
    private String cancelOrderNo;

    /**
     * 渠道交易流水号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "transactionId长度不能超过32")
    private String transactionId;

    /**
     * 渠道撤销流水号
     *
     * (选填)
     */
    @Length(max = 32, message = "cancelId长度不能超过32")
    private String cancelId;

    /**
     * 是否有资金流向(只有支付宝有该字段)
     *
     * (选填)
     */
    @Length(max = 8, message = "fundChange长度不能超过8")
    private String fundChange;

    /**
     * 是否需要新调用撤销(当为Y时，需要重新调用撤销接口)
     *
     * (选填)
     */
    @Length(max = 8, message = "recall长度不能超过8")
    private String recall;

    /**
     * 富友交易日期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "reservedFySettleDt长度不能超过8")
    private String reservedFySettleDt;

    /**
     * 富友系统内部追踪号
     *
     * (选填)
     */
    @Length(max = 12, message = "reservedFyTraceNo长度不能超过12")
    private String reservedFyTraceNo;

}