/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.response.merchant.item.FuiouWechatConfigInfoResponse;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version FuiouWechatConfigResponse.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouWechatConfigResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555448296482L;


    /**
     * 流水号
     * (选填)
     */
    private String traceNo;

    /**
     * 响应结果
     * (必填)
     */
    private String retCode;

    /**
     * 响应对应中文解释
     * (必填)
     */
    private String retMsg;

    /**
     * 配置响应结果（参数如下）
     * (选填)
     */
    private List<FuiouWechatConfigInfoResponse> configs;
}