/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouSubMerchantQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouSubMerchantQueryRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouSubMerchantQueryRequest extends FuiouBizRequest<FuiouSubMerchantQueryResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555796831650L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    private String traceNo;

    /**
     * 申请商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 1:微信 2：支付宝 3：微信绿洲 4：支付宝蓝海 5：翼支付 6：银联二维码
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "mchntTp长度不能超过1")
    private String mchntTp;

}