/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.enums.merchant;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.request.merchant.FuiouAgreementCreateRequest;
import com.fshows.fuiou.request.merchant.FuiouAgreementSignRequest;
import com.fshows.fuiou.request.merchant.FuiouAuditQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouBaseInfoUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouCallbackAddressQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouCallbackAddressRequest;
import com.fshows.fuiou.request.merchant.FuiouCommitFinishRequest;
import com.fshows.fuiou.request.merchant.FuiouEquipmentBindRequest;
import com.fshows.fuiou.request.merchant.FuiouEquipmentUnBindRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantIncomeRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantSignRequest;
import com.fshows.fuiou.request.merchant.FuiouMerchantUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouPicUploadRequest;
import com.fshows.fuiou.request.merchant.FuiouQueryTerminalRequest;
import com.fshows.fuiou.request.merchant.FuiouRateUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouSettleUpdateRequest;
import com.fshows.fuiou.request.merchant.FuiouQuerySignStatusRequest;
import com.fshows.fuiou.request.merchant.FuiouSubMerchantQueryRequest;
import com.fshows.fuiou.request.merchant.FuiouTermCollectRequest;
import com.fshows.fuiou.request.merchant.FuiouUnionpayApplyRequest;
import com.fshows.fuiou.request.merchant.FuiouWechatConfigRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.response.merchant.*;

/**
 * @author zhubo
 * @version FuiouMerchantApiDefinitionEnum.java, v 0.1 2023-09-11 11:38 zhubo
 */
public enum FuiouMerchantApiDefinitionEnum implements IFuiouApiDefinition {
    MERCHANT_INCOME(
            "商户信息登记接口",
            "/wxMchntMng.fuiou?action=wxMchntAdd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantIncomeRequest.class,
            FuiouMerchantIncomeResponse.class

    ),
    MECHANT_UPDATE(
            "商户信息更新接口",
            "/wxMchntMng.fuiou?action=wxMchntUpd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantUpdateRequest.class,
            FuiouMerchantUpdateResponse.class
    ),
    SETTLE_UPDATE(
            "入账信息变更接口v2",
            "/wxMchntUpd.fuiou?action=mchntAcntUpdV2",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouSettleUpdateRequest.class,
            FuiouSettleUploadResponse.class
    ),
    PICTURE_UPLOAD(
            "统一图片上传接口",
            "/upload.fuiou?action=uploadImg",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouPicUploadRequest.class,
            FuiouPicUploadResponse.class
    ),
    RATE_UPDATE(
            "扣率信息变更(收单常规)",
            "/wxMchntUpd.fuiou?action=mchntCalcUpdSD",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouRateUpdateRequest.class,
            FuiouRateUploadResponse.class
    ),
    WECHAT_CONFIG(
            "微信参数配置接口",
            "/wxMchntMng.fuiou?action=xyWechatConfigSet",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouWechatConfigRequest.class,
            FuiouWechatConfigResponse.class
    ),
    AGREEMENT_CREATE(
            "电子协议生成",
            "/wxMchntMng.fuiou?action=elecContractGenerate",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAgreementCreateRequest.class,
            FuiouAgreementCreateResponse.class
    ),
    AGREEMENT_SIGN(
            "电子协议签署",
            "/wxMchntMng.fuiou?action=elecContractSign",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAgreementSignRequest.class,
            FuiouAgreementSignResponse.class
    ),
    COMMIT_FINISH(
            "附件提交完成接口",
            "/wxMchntMng.fuiou?action=attachConfirm",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouCommitFinishRequest.class,
            FuiouCommitFinishResponse.class
    ),
    MERCHANT_QUERY(
            "商户信息查询接口",
            "/wxMchntMng.fuiou?action=getMchntInfAndConfig",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantQueryRequest.class,
            FuiouMerchantQueryResponse.class
    ),
    AUDIT_QUERY(
            "业务审核状态查询接口",
            "/wxMchntMng.fuiou?action=mchntQueryTZ",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouAuditQueryRequest.class,
            FuiouAuditQueryResponse.class
    ),
    UNIONPAY_APPLY(
            "银联二维码业务申请开通接口",
            "/wxMchntMng.fuiou?action=mchntOpenUpayQr",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouUnionpayApplyRequest.class,
            FuiouUnionpayApplyResponse.class
    ),
    SUB_MERCHANT_QUERY(
            "商户渠道子商户号查询接口",
            "/wxMchntMng.fuiou?action=chnlSubMchIdQuery",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouSubMerchantQueryRequest.class,
            FuiouSubMerchantQueryResponse.class
    ),
    CALLBACK_ADDRESS(
            "回调地址设置接口",
            "/notifyConfig.fuiou?action=notifyConfig",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouCallbackAddressRequest.class,
            FuiouCallbackAddressResponse.class
    ),
    CALLBACK_ADDRESS_QUERY(
            "回调地址查询接口",
            "/notifyConfig.fuiou?action=queryNotifyConfig",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouCallbackAddressQueryRequest.class,
            FuiouCallbackAddressQueryResponse.class
    ),
    EQUIPMENT_BIND(
            "新增终端",
            "/term.fuiou?action=termAdd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouEquipmentBindRequest.class,
            FuiouEquipmentBindResponse.class
    ),
    EQUIPMENT_UNBIND(
            "终端撤机",
            "/term.fuiou?action=termCancel",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouEquipmentUnBindRequest.class,
            FuiouEquipmentUnBindResponse.class
    ),
    TERM_COLLECT(
            "商户终端信息采集报备",
            "/term.fuiou?action=termCollect",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouTermCollectRequest.class,
            FuiouTermCollectResponse.class
    ),
    BASE_INFO_UPDATE(
            "基础信息更新接口",
            "/wxMchntUpd.fuiou?action=mchntBasicUpd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouBaseInfoUpdateRequest.class,
            FuiouBaseInfoUpdateResponse.class
    ),
    WECHAT_CONFIG_QUERY(
            "微信参数配置查询接口",
            "/wxMchntMng.fuiou?action=xyWechatConfigGet",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouWechatConfigRequest.class,
            FuiouWechatConfigResponse.class
    ),
    QUERY_TERMINAL(
            "终端查询",
            "/term.fuiou?action=termQuery",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouQueryTerminalRequest.class,
            FuiouQueryTerminalResponse.class
    ),
    MERCHANT_SIGN(
            "电子协议签约",
            "/mchntsignv2.fuiou?action=elecContractSignV2",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouMerchantSignRequest.class,
            FuiouMerchantSignResponse.class
    ),
    QUERY_SIGN_STATUS(
            "电子协议签约",
            "/mchntsignv2.fuiou?action=elecContractSignV2StatusQuery",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouQuerySignStatusRequest.class,
            FuiouQuerySignStatusResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    FuiouMerchantApiDefinitionEnum(String name, String apiSubURI, String version, Class requestClass, Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public <T extends FuiouBizRequest> Class<T> getRequestClass() {
        return requestClass;
    }

    @Override
    public <T extends FuiouBizResponse> Class<T> getResponseClass() {
        return responseClass;
    }
}