/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 充值记账接口
 *
 * @author
 * @version FuStdRechargeTradeAllocateRes.java, v 0.1 2024-01-02 15:29:26
 */
@Data
public class FuStdRechargeTradeAllocateRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555988527876L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 交易日期
     * 发起日期
     * (必填)
     */
    @NotBlank
    private String allocateDate;

    /**
     * 富友批次号
     * 
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 源支付订单号
     * 富友支付参考流水号
     * (必填)
     */
    @NotBlank
    private String srcFasSsn;

    /**
     * 源交易日期
     * YYYYMMdd
     * (必填)
     */
    @NotBlank
    private String srcFasDate;

}