/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 归集撤销接口
 *
 * @author
 * @version FuStdCancleConcentrateTradeRes.java, v 0.1 2024-01-02 16:38:11
 */
@Data
public class FuStdCancleConcentrateTradeRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555470001452L;


    /**
     * 商户流水号
     * 
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 业务类型
     * 01 订单归集
02 资金归集
     * (必填)
     */
    @NotBlank
    private String busiType;

    /**
     * 源归集交易富友批次号
     * 
     * (必填)
     */
    @NotBlank
    private String srcBatchNo;

    /**
     * 源归集交易金额
     * 
     * (必填)
     */
    @NotNull
    private Integer srcAmt;

}