/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.steward.response.query.item;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 *
 * @author liluqing
 * @version FuStdQueryBookTradeItem.java, v 0.1 2024-01-08 19:18
 */
@Data
public class FuStdQueryBookTradeItem {

    /**
     * 交易时间
     * yyyy-MM-dd HH:mm:ss
     * (必填)
     */
    @NotBlank
    private String tradeTime;

    /**
     * 富友批次号
     *
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 源交易商户流水号
     * 商户流水号
     * (选填)
     */
    private String mchntCdTraceNo;

    /**
     * 源交易商户子流水号
     * 商户子流水号
     * (选填)
     */
    private String mchntCdChildTraceNo;

    /**
     * 富友交易参考号
     *
     * (必填)
     */
    @NotBlank
    private String srcFasSsn;

    /**
     * 交易金额
     * 单位：分
     * (必填)
     */
    @NotNull
    private Integer txnAmt;

    /**
     * 转出用户编号或商户号
     *
     * (必填)
     */
    @NotBlank
    private String accountOut;

    /**
     * 转入用户编号或商户号
     *
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 状态
     * 01 处理中
     05 成功
     06 失败
     07 已撤销
     08 有回退
     * (必填)
     */
    @NotBlank
    private String status;

    /**
     * 失败原因
     * 当状态为 06 时返回
     * (选填)
     */
    private String errorMsg;

    /**
     * 交易类型
     *
     * (必填)
     */
    @NotBlank
    private String tradeType;
}