/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.response.query;

import com.fshows.steward.response.FuStewardBizResponse;
import com.fshows.steward.response.query.item.FuStdQueryMchntDrawoutItem;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author wangyi
 * @version FuStdQueryMchntDrawoutRes.java, v 0.1 2024-11-08 01:36 wangyi
 */
@Data
public class FuStdQueryMchntDrawoutRes extends FuStewardBizResponse {
    private static final long serialVersionUID = 5038176295556947032L;

    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 被归集商户号
     * 需加白。传入该字段查询的是被归集商户的记账户明细
     */
    private String mchntCdConcentrate;

    /**
     * 起始日期
     * 起始日期,YYYYMMdd
     */
    @Length(max = 8, message = "beginDate长度不能超过8")
    private String beginDate;

    /**
     * 截止日期
     * 截止日期,YYYYMMdd
     */
    @Length(max = 8, message = "endDate长度不能超过8")
    private String endDate;

    /**
     * 查询结果总数
     * 查询结果总数
     * (必填)
     */
    @NotNull
    private Integer totalNum;

    /**
     * 记账类交易列表
     */
    private List<FuStdQueryMchntDrawoutItem> items;
}