/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 用户子账户创建接口
 *
 * @author
 * @version FuStdCloneCustomerReq.java, v 0.1 2023-12-28 15:45:17
 */
@Data
public class FuStdCloneCustomerReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555705167357L;


    /**
     * 交易流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 源用户编号
     * 源分账入账方编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "srcAccountIn长度不能超过30")
    private String srcAccountIn;

    /**
     * 备注
     * 备注
     * (特殊必填)
     */
    @Length(max = 50, message = "remark长度不能超过50")
    private String remark;

}