/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

/**
 * @author zhubo
 * @version FuiouCallbackAddressQueryResponse.java, v 0.1 2024-04-02 14:59 zhubo
 */
@Data
public class FuiouCallbackAddressQueryResponse extends FuiouBizResponse {
    private static final long serialVersionUID = 1929731117644638015L;

    /**
     * 唯一流水号
     * (必填)
     */
    private String traceNo;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    private String insCd;

    /**
     * 0关闭，1开通
     * (必填)
     */
    private String notifyEmailFlag;

    /**
     * 回调url
     * (选填)
     */
    private String notifyUrl;

    /**
     * 0关闭，1开通
     * (必填)
     */
    private String notifyUrlFlag;

    /**
     * 回调通知类型： 渠道报备通知：report； 整改协查通知：mchtreform 收单审核结果通知：accept
     * (必填)
     */
    private String notifyType;

    /**
     * 回调email，多邮箱时用”,”分隔（英文逗号）。如：”A@fuiou.com,B@fuiou.com”
     * (选填)
     */
    private String notifyEmails;

    /**
     * 签名
     */
    private String sign;

    /**
     * 响应码
     */
    private String resultCode;

    /**
     * 响应信息
     */
    private String resultMsg;
}
