/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouSettleUploadResponse;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author
 * @version FuiouSettleUpdateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouSettleUpdateRequest extends FuiouBizRequest<FuiouSettleUploadResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555390257150L;


    /**
     * 唯一流水号
     * (必填)
     */
    @NotNull
    private String traceNo;

    /**
     * 已在富友入网的富友商户代码
     * (必填)
     */
    @NotNull
    private String fyMchntCd;

    /**
     * 需要更改的结算卡类型 01 对公，02对私，04双账户
     * (必填)
     */
    @NotNull
    private String destAcntType;

    /**
     * 对私行别
     * (选填)
     */
    private String bankTypeS;

    /**
     * 对私入账卡开户行联行号见附件9 开户行信息列表
     * (选填)
     */
    private String interBankNoS;

    /**
     * 对私入账卡开户行（在联行号找不到时生效）
     * (选填)
     */
    private String issBankNmS;

    /**
     * 对私入账卡户名
     * (选填)
     */
    private String acntNmS;

    /**
     * 对私入账卡号（不带长度位）
     * (选填)
     */
    private String acntNoS;

    /**
     * 对私户入账手机号
     * (选填)
     */
    private String acntContactMobileS;

    /**
     * 对私省代码
     * (选填)
     */
    private String provCdS;

    /**
     * 对私市代码
     * (选填)
     */
    private String cityCdS;

    /**
     * 对公行别
     * (选填)
     */
    private String bankTypeG;

    /**
     * 对公入账卡开户行联行号见附件9 开户行信息列表
     * (选填)
     */
    private String interBankNoG;

    /**
     * 对公入账卡开户行（在联行号找不到时生效）
     * (选填)
     */
    private String issBankNmG;

    /**
     * 对私入账卡户名
     * (选填)
     */
    private String acntNmG;

    /**
     * 对公入账卡号（不带长度位）
     * (选填)
     */
    private String acntNoG;

    /**
     * 对公省代码
     * (选填)
     */
    private String provCdG;

    /**
     * 对公市代码
     * (选填)
     */
    private String cityCdG;

    /**
     * 入账人身份证号
     * (选填)
     */
    private String acntCertifId;

    /**
     * 到期日期
     * (选填)
     */
    private String acntCertifExpireDt;

    /**
     * 法人入账标识(0:非法人入账,1:法人入账若license_type=A，这此字段必须填：1:法人入账)
     * (选填)
     */
    private String acntArtifFlag;

    /**
     * 入账证件类型("0":"身份证"【默认】【acnt_artif_flag = 0时必填】
     * (选填)
     */
    private String acntCertifTp;

    /**
     * 银行卡正面照d2f8d0d0bfa8d5fdc3e6d5d5
     * (选填)
     */
    private String bankFrontImgId;

    /**
     * 对公户照片（开户许可证、印鉴卡、单位结算卡、开户回执、银行对账单、网银截图）b6d4b9abbba7d5d5c6ac
     * (选填)
     */
    private String publicActImgId;

    /**
     * 商户关系证明协议（入账非法人提供）c9ccbba7b9d8cfb5d6a4c3f7d0add2e9
     * (选填)
     */
    private String proofMchntImgId;

    /**
     * 身份证和银行卡手持证件照，开通D0业务需要上传c9edb7ddd6a4bacdd2f8d0d0bfa8cad6b3d6d6a4bcfed5d5
     * (选填)
     */
    private String cardBankScImgId;

    /**
     * 对私账户身份证明正面b6d4cbbdd5cbbba7c9edb7ddd6a4c3f7d5fdc3e6
     * (选填)
     */
    private String privateCardFrontImgId;

    /**
     * 对私账户身份证明背面b6d4cbbdd5cbbba7c9edb7ddd6a4c3f7b1b3c3e6
     * (选填)
     */
    private String privateCardBackImgId;

}