/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FgjCreateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouFgjBeneRequest implements Serializable {

    private static final long serialVersionUID = -4309248770322102250L;
    /**
     * 受益人姓名
     * (必填)
     */
    @NotBlank(message = "参数格式错误:受益人姓名不允许为空")
    @Length(max = 15, message = "受益人姓名长度不能超过15")
    @JSONField(name = "bene_nm")
    private String beneNm;
    /**
     * 受益人地址
     * (必填)
     */
    @NotBlank(message = "参数格式错误:受益人地址不允许为空")
    @Length(max = 64, message = "受益人地址长度不能超过64")
    @JSONField(name = "bene_addr")
    private String beneAddr;
    /**
     * 受益人手机号
     */
    @Length(max = 11, message = "受益人手机号长度不能超过11")
    @JSONField(name = "bene_mobile")
    private String beneMobile;

    /**
     * 受益人证件类型
     * 0:身份证
     * 1:护照
     * 2:军官证
     * 9:警察证
     * B:通行证
     */
    @NotBlank(message = "参数格式错误:受益人证件类型不允许为空")
    @JSONField(name = "bene_certif_tp")
    private String beneCertifTp;
    /**
     * 受益人证件号码
     */
    @NotBlank(message = "参数格式错误:受益人证件号码不允许为空")
    @Length(max = 24, message = "受益人证件号码长度不能超过24")
    @JSONField(name = "bene_certif_no")
    private String beneCertifNo;
    /**
     * 受益人证件开始日
     */
    @Length(max = 8, message = "受益人证件开始日长度不能超过8")
    @JSONField(name = "bene_start_dt")
    private String beneStartDt;
    /**
     * 受益人证件到期日
     * 长期请填20991231
     */
    @NotBlank(message = "参数格式错误:受益人证件有效期不允许为空")
    @Length(max = 8, message = "受益人证件有效期长度不能超过8")
    @JSONField(name = "bene_expire_dt")
    private String beneExpireDt;
    /**
     * 受益所有人认定类型
     * 0:股权
     * 1:表决权
     * 2:高级管理员
     * 3:其他
     */
    @NotBlank(message = "参数格式错误:受益人认定类型不允许为空")
    @JSONField(name = "bene_role")
    private String beneRole;
    /**
     * 持股数量（%）
     */
    @Length(max = 5, message = "stockRate长度不能超过5")
    @JSONField(name = "stock_rate")
    private String stockRate;
    /**
     * 直接持股等
     */
    @Length(max = 16, message = "beneType长度不能超过16")
    @JSONField(name = "bene_type")
    private String beneType;

}