/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.steward.request.trade.item;

import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liubo
 * @version FustdAccountInListReq.java, v 0.1 2024-01-02-10:06 上午 liubo
 */
@Data
public class FustdSubAccountInListReq {


    /**
     * 转入用户编号
     * 分
     * (必填)
     */
    @NotNull
    private String accountIn;
    /**
     * 转账金额
     * 分
     * (必填)
     */
    @NotNull
    private Integer amt;

    /**
     * 转账子流水号
     * 唯一流水号，商户定义
     * (选填)
     */
    @Length(max = 30, message = "transTraceNo长度不能超过30")
    @NoSign
    private String transTraceNo;

    /**
     * 商户服务费金额
     * 非必填
     * (选填)
     */
    @NoSign
    private Integer fee;

    /**
     * 服务费子流水号
     * 唯一流水号，商户定义
     * (选填)
     */
    @Length(max = 30, message = "feeTraceNo长度不能超过30")
    @NoSign
    private String feeTraceNo;

    /**
     * 服务费扣收方式
     * 内扣 1/外扣 2,服务金额不为 空时必填
     * (选填)
     */
    @Length(max = 1, message = "feeType长度不能超过1")
    @NoSign
    private String feeType;

    /**
     * 服务费收入账户
     * 服务费收入账户：非必填，支持传入商户自有子账户，不填时默认商户收款账户
     * (选填)
     */
    @Length(max = 40, message = "feeAccount长度不能超过40")
    @NoSign
    private String feeAccount;

    /**
     * 原预授权协议号
     * 预留字段
     * (选填)
     */
    @Length(max = 50, message = "srcProtocol长度不能超过50")
    @NoSign
    private String srcProtocol;

    /**
     * 转账方式
     * 1(转账记账)/2(自动结算)
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "transferType长度不能超过1")
    @NoSign
    private String transferType;

    /**
     * 转入方结算卡号
     * 转账方式=2 必传需为转入方用户绑定且生效的卡
     * (选填)
     */
    @Length(max = 20, message = "cardNo长度不能超过20")
    @NoSign
    private String cardNo;


}