/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 商户结算接口
 *
 * @author
 * @version FuStdMchntDrawoutReq.java, v 0.1 2024-01-02 16:29:28
 */
@Data
public class FuStdMchntDrawoutReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555382721600L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 结算账户类型
     * 01 对私， 02 对公 不传默认系统结算类型
     * (选填)
     */
    @Length(max = 2, message = "cleanType长度不能超过2")
    private String cleanType;

    /**
     * 结算金额
     * 结算金额
     * (必填)
     */
    @NotNull
    private Integer cleanAmt;

    /**
     * 打款附言
     * 
     * (选填)
     */
    @Length(max = 30, message = "remark长度不能超过30")
    private String remark;

}