/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.response.merchant.item.FuiouChannelInfoResponse;
import com.fshows.fuiou.response.merchant.item.FuiouRateInfoResponse;
import com.fshows.fuiou.response.merchant.item.FuiouSettleInfoResponse;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version FuiouMerchantQueryResponse.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouMerchantQueryResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555958139873L;


    /**
     * 二级机构号
     * (必填)
     */
    private String subInsCd;

    /**
     * 唯一流水号
     * (必填)
     */
    private String traceNo;

    /**
     * 商户号
     * (选填)
     */
    private String mchntCd;

    /**
     * 商户名称
     * (选填)
     */
    private String mchntName;

    /**
     * 商户简称，不能有特殊字符，仅可包含汉字、数字、字母
     * (选填)
     */
    private String mchntShortname;

    /**
     * 商户真实名称（与营业执照上相同） 商户全称（企业名称）
     * (选填)
     */
    private String realName;

    /**
     * 商户开通状态（1：开通，0：关闭）
     * (必填)
     */
    private String insSt;

    /**
     * 支付宝开通状态（0：未开通，1：开通成功，2：通道报备中，9：开通失败）
     * (必填)
     */
    private String aliFlag;

    /**
     * 微信开通状态（0：未开通，1：开通成功，2：通道报备中，9：开通失败）
     * (必填)
     */
    private String wxFlag;

    /**
     * pos刷卡开通标记（0：未开通，1：开通成功，2：通道报备中，9：开通失败）
     * (必填)
     */
    private String posFlag;

    /**
     * 微信经营类目
     * (必填)
     */
    private String business;

    /**
     * 响应结果
     * (必填)
     */
    private String retCode;

    /**
     * 响应对应中文解释
     * (选填)
     */
    private String retMsg;

    /**
     * 证件类型: 0 营业执照 1 三证合一 A 身份证（一证下机） B 个体户
     * (必填)
     */
    private String licenseType;

    /**
     * 证件号码
     * (必填)
     */
    private String licenseNo;

    /**
     * 证件到期日
     * (必填)
     */
    private String licenseExpireDt;

    /**
     * 法人姓名
     * (必填)
     */
    private String artifNm;

    /**
     * 法人身份证号
     * (必填)
     */
    private String certifId;

    /**
     * 法人身份证到期日
     * (必填)
     */
    private String certifIdExpireDt;

    /**
     * 联系人姓名
     * (必填)
     */
    private String contactPerson;

    /**
     * 联系电话
     * (必填)
     */
    private String contactMobile;

    /**
     * 客服电话
     * (必填)
     */
    private String contactPhone;

    /**
     * 联系邮箱
     * (必填)
     */
    private String contactEmail;

    /**
     * 省
     * (必填)
     */
    private String provCd;

    /**
     * 市代码
     * (必填)
     */
    private String cityCd;

    /**
     * 区代码
     * (必填)
     */
    private String countyCd;

    /**
     * 清算类型 1--自动结算(T1) 2--手动结算 3--自动结算（D1） 4--定时结算
     * (必填)
     */
    private String settleTp;

    /**
     * 商户经营地联系地址
     * (必填)
     */
    private String contactAddr;

    /**
     * 营业执照注册地址
     * (选填)
     */
    private String licRegisAddr;

    /**
     * 清算时间（settleTp=4时返回）
     * (选填)
     */
    private String settleTs;

    /**
     * 微信预授权开通标志（0：不开通,1：开通）
     * (必填)
     */
    private String wxPreFlag;

    /**
     * 微信预授权扣率套餐代码
     * (选填)
     */
    private String wxPreSetCd;

    /**
     * 支付宝预授权标识（0：不开通,1：开通）
     * (必填)
     */
    private String aliPreFlag;

    /**
     * 支付宝预授权扣率套餐代码
     * (选填)
     */
    private String aliPreSetCd;

    /**
     * 是否开通灵活结算及结算方式 （返回空：表示没有开通灵活结算 01:开通&自动 03:开通&手动）
     * (选填)
     */
    private String activeClean;

    /**
     * 是否开通富管家（01:开通 非01：表示没有开通富管家）
     * (选填)
     */
    private String allocateClean;

    /**
     * 结算信息列表
     */
    private List<FuiouSettleInfoResponse> mchntAcntInfList;

    /**
     * 渠道配置信息列表
     */
    private List<FuiouChannelInfoResponse> mchntChnlInfList;

    /**
     * 费率信息列表
     */
    private List<FuiouRateInfoResponse> mchntSetCdList;
}