/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.response.coupon;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author mengqf
 * @version FuiouCouponTransferQueryResponse.java, v 0.1 2024-08-16 16:49 mengqf
 */
@Data
public class FuiouCouponTransferQueryResponse extends FuiouBizResponse implements Serializable {
    private static final long serialVersionUID = 2812157998656094203L;

    /**
     * 营销账号-转出的商户号
     * (必填)
     */
    private String accountIn;

    /**
     * 明细列表
     */
    DetailList list;

    /**
     * 备注
     */
    private String remark;

    @Data
    public static class DetailList {

        List<Detail> item;

        @Data
        public static class Detail {
            /**
             * 入账商户号
             * (必填)
             */
            private String mchntCd;

            /**
             * 手续费
             */
            private Integer feeAmt;

            /**
             * 转账金额
             */
            private Integer txnAmt;

            /**
             * 转账类型
             * 1：营销
             * 2: 核销转账
             * (必填)
             */
            private String transType;

            /**
             * 转账日期 yyyyMMdd
             */
            private String transDate;

            /**
             * 唯一流水号
             * (必填)
             */
            private String traceNo;

            /**
             * 交易状态
             * 1-成功
             * 2-失败
             * 7-超时
             * -1-撤销
             */
            private String status;

            /**
             * 富友交易参考号
             */
            private String fasSsn;
        }
    }
}