/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.trade.pay;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 花呗分期请求
 *
 * @author
 * @version FuiouReservedAliExtendParamsRequest.java, v 0.1 2023-09-15 17:08
 */
@Data
public class FuiouReservedAliExtendParamsRequest implements Serializable {

    private static final long serialVersionUID = -4396864911727423911L;
    /**
     * 花呗分期期数：仅支持3、6、12
     */
    @Length(max = 3, message = "hbFqNum长度不能超过3")
    private String hbFqNum;

    /**
     * 花呗分期商家手续费比例，目前仅支持用户出资，如需使用，请填写0！
     * 目前该字段未生效，我司会默认当0处理。
     */
    @Length(max = 3, message = "hbFqSellerPercent长度不能超过3")
    private String hbFqSellerPercent;

    /**
     * 行业数据回流信息
     * 示例值：{"scene_code":"metro_tradeorder",
     *         "channel":"xxxx",
     *         "scene_data":{"asset_name":"ALIPAY"}}
     */
    @Length(max = 512, message = "industryRefluxInfo长度不能超过512")
    private String industryRefluxInfo;

    /**
     * 条码支付中，目前支持的用法为：sence_no
     */
    @Length(max = 128, message = "dynamicTokenOutBizNo长度不能超过128")
    private String dynamicTokenOutBizNo;

    /**
     * 信用卡分期期数：仅支持3、6、12
     */
    @Length(max = 3, message = "fqNum长度不能超过3")
    private String fqNum;

    /**
     * 信用卡分期商家手续费比例，目前仅支持用户出资，如需使用，请填写0！
     * 目前该字段未生效，我司会默认当0处理。
     */
    @Length(max = 3, message = "fqSellerPercent长度不能超过3")
    private String fqSellerPercent;

    /**
     * 优先使用该资产进行支付，信用卡分期时传入，目前只支持传alipayfq_cc
     */
    @Length(max = 20, message = "fqChannels长度不能超过20")
    private String fqChannels;

    /**
     * 点餐场景类型：
     * qr_order(店内扫码点餐)，
     * pre_order(预点到店自提)，
     * home_delivery(外送到家)，
     * direct_payment(直接付款)，
     * other(其他)
     */
    @Length(max = 32, message = "foodOrderType长度不能超过32")
    private String foodOrderType;

}