/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouAgreementSignResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouAgreementSignRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouAgreementSignRequest extends FuiouBizRequest<FuiouAgreementSignResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555431420245L;
    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 验证码
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "verifyNo长度不能超过16")
    @JSONField(name = "verify_no")
    private String verifyNo;

    /**
     * 协议编号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "contractNo长度不能超过15")
    @JSONField(name = "contract_no")
    private String contractNo;

}