/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhoujp
 * @version FuiouFgjShareHoldImgUploadRequest.java, v 0.1 2024-07-23 15:45 zhoujp
 */
@Data
public class FuiouFgjShareHoldImgUploadRequest implements Serializable {

    private static final long serialVersionUID = -2544803536467698760L;
    /**
     * 证件号码
     */
    @Length(max = 24, message = "shareholdCertifNo长度不能超过24")
    @JSONField(name = "sharehold_certif_no")
    private String shareholdCertifNo;

    /**
     * 国徽面-扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "shareholderZmImgId长度不能超过40")
    @JSONField(name = "sharehold_zm_img_id")
    private String shareholdZmImgId;

    /**
     * 人像面-扫描照片
     * 图片上传接口返回的对应media_id
     */
    @Length(max = 40, message = "shareholderFmImgId长度不能超过40")
    @JSONField(name = "sharehold_fm_img_id")
    private String shareholdFmImgId;
}