/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.coupon;

import com.fshows.fuiou.enums.FuiouCouponDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferCancelResponse;
import com.fshows.fuiou.response.trade.pay.FuiouPreOrderResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouCouponTransferCancelRequest.java, v 0.1 2024-08-16 16:45 mengqf
 */
@Data
public class FuiouCouponTransferCancelRequest extends FuiouBizRequest<FuiouCouponTransferCancelResponse, FuiouCouponDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = -6995514774676318141L;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo不能超过30位")
    private String traceNo;

    /**
     * 营销账号-转出的商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn不能超过40位")
    private String accountIn;

    /**
     * 入账商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "mchntCd不能超过40位")
    private String mchntCd;

    /**
     * 退回金额 单位：分
     * (必填)
     */
    @NotNull
    private Integer txnAmt;

    /**
     * 源转账交易流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "srcTraceNo不能超过30位")
    private String srcTraceNo;

    /**
     * 转账日期 yyyyMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "transDate不能超过8位")
    private String transDate;

    /**
     * 备注
     */
    @Length(max = 128, message = "remark不能超过128位")
    private String remark;
}