package com.fshows.fuiou.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 富友交易API响应码枚举
 *
 * @author liluqing
 * @version FuiouTradeResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum FuiouTradeResponseCodeEnum {
    SUCCESS("成功", "BBS00000"),
    PAYING("交易状态为支付中", "BBS10000")
    ;

    private String name;
    private String value;

    FuiouTradeResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static FuiouTradeResponseCodeEnum getByValue(String value) {
        FuiouTradeResponseCodeEnum[] valueList = FuiouTradeResponseCodeEnum.values();
        for (FuiouTradeResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}