/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fuiou.client.base;

import com.fshows.fuiou.exception.FuiouApiException;

import java.util.Map;

/**
 * @author liluqing
 * @version Signer.java, v 0.1 2022-03-02 7:51 PM liluqing
 */
public interface ISigner {

    /**
     * 加签
     *
     * @param signParam       签名参数
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException;

    /**
     * 验签
     *
     * @param resMap            签名值
     * @param verifySignParam       签名参数
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws FuiouApiException;
}
