/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.impl.AbstractFuiouApiClientImpl;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.XmlConvertUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponFuiouApiClientImpl
extends AbstractFuiouApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CouponFuiouApiClientImpl.class);

    public CouponFuiouApiClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig);
    }

    public CouponFuiouApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition couponDefinitionEnum) {
        request.setInsCd(this.apiClientConfig.getAppId());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest bizRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setRequest(bizRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition couponDefinitionEnum) {
        Map<String, String> requstMap = FuiouRequestUtils.toResultMap(fuiouBaseRequest, true);
        requstMap.put("signature", sign);
        requstMap.remove("sign");
        requstMap.remove("version");
        requstMap.remove("randomKey");
        return FuiouRequestUtils.generateXml(requstMap);
    }

    @Override
    protected FuiouBizResponse parseResponse(String body, IFuiouApiDefinition couponDefinitionEnum) throws FuiouApiException {
        try {
            Map resMap = XmlConvertUtil.xml2Bean(body, Map.class);
            FuiouBizResponse fuiouBizResponse = (FuiouBizResponse)FuiouRequestUtils.getObjectFromMap(resMap, couponDefinitionEnum.getResponseClass());
            fuiouBizResponse.setResultCode(resMap.getOrDefault("respCode", "9999"));
            fuiouBizResponse.setResultMsg(resMap.getOrDefault("respDesc", "\u8c03\u7528\u5bcc\u53cb\u5f02\u5e38"));
            fuiouBizResponse.setResultCode("0000".equals(fuiouBizResponse.getResultCode()) ? "000000" : fuiouBizResponse.getResultCode());
            fuiouBizResponse.setResMap(resMap);
            return fuiouBizResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, body);
            throw new FuiouApiException("[fuiou-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R couponDefinitionEnum) throws FuiouApiException {
        return (T)super.doExecute(request, couponDefinitionEnum);
    }
}

