/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.query;

import com.fshows.steward.response.FuStewardBizResponse;
import com.fshows.steward.response.query.item.FuStdQueryBookTradeItem;
import lombok.Data;


import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 记账类交易结果查询接口
 *
 * @author
 * @version FuStdQueryBookTradeRes.java, v 0.1 2024-01-08 19:05:45
 */
@Data
public class FuStdQueryBookTradeRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555574501287L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 起始日期
     * 起始日期,YYYYMMdd
     * (必填)
     */
    @NotBlank
    private String startDate;

    /**
     * 截止日期
     * 截止日期,YYYYMMdd
     * (必填)
     */
    @NotBlank
    private String endDate;

    /**
     * 查询结果总数
     * 查询结果总数
     * (必填)
     */
    @NotNull
    private Integer totalNum;

    /**
     * 记账类交易列表
     */
    private List<FuStdQueryBookTradeItem> items;
}