/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 普通入账方协议修改接口
 *
 * @author
 * @version FuStdModifyProtocolRes.java, v 0.1 2023-12-28 15:35:33
 */
@Data
public class FuStdModifyProtocolRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555547743155L;


    /**
     * 商户流水号
     * 
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 入账方编号
     * 
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * url
     * 签约的 url
     * (选填)
     */
    private String url;

}