/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.steward.request.trade.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author liubo
 * @version FustdSrcFasSsnListReq.java, v 0.1 2024-01-02-10:03 上午 liubo
 */
@Data
public class FustdSrcFasSsnListReq {

    /**
     * 订单流水号列表
     * 富友支付参考流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "srcFasSsn长度不能超过12")
    private String srcFasSsn;

    /**
     * 源交易日期
     * YYYYMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "srcFasDate长度不能超过8")
    private String srcFasDate;
}